/** @file   RocketBullet.h
 * @brief   Declaration of RocketBullet class.
 * @version $Revision: 1.1.1.1 $
 * @date    $Date: 2006/01/21 23:02:42 $
 * @author  Tomi Lamminsaari
 */

#ifndef H_WWW_ROCKETBULLET_H
#define H_WWW_ROCKETBULLET_H

#include "bullet.h"

namespace WeWantWar {

/** @class  RocketBullet
 * @brief   Represents the rocket launched by RocketLauncher
 * @author  Tomi Lamminsaari
 *
 */
class RocketBullet : public Bullet
{
public:

  ///
  /// Constants, datatypes and static methods
  /// =======================================

  ///
  /// Constructors, destructor and operators
  /// ======================================

  /** Default constructor.
   * @param   aShooter          Pointer to GameObject who shot this bullet.
   * @param   aPos              Starting position of the bullet.
   */
  RocketBullet( GameObject* aShooter, const eng2d::Vec2D& aPos );

  /** Destructor
   */
  ~RocketBullet();

private:
  
  /** Copy constructor
   * @param   aAnother          Reference to another RocketBullet
   */
  RocketBullet( const RocketBullet& aAnother );

  /** An assignment operator
   * @param   aAnother          Reference to another RocketBullet
   * @return  Reference to this object.
   */
  RocketBullet& operator= ( const RocketBullet& aAnother );

public:

  ///
  /// Inherited methods
  /// =================

  /** Draws this bullet.
   * @param   aBitmap           pointer to target bitmap.
   */
  virtual void redraw( BITMAP* aBitmap ) const;
  
  /** Generates an explosion once this rocket has reached its end.
   * @param   aBulletTable      Pointer to BulletTable where we spawn the
   *                            emitted bullets.
   */
  virtual void endingActions( BulletTable* aBulletTable );

};

};  // end of namespace

#endif
